const nextButton = document.getElementById('next-button');
const flashcardContainer = document.getElementById('flashcard-container');
const playAudioButton = document.getElementById('play-audio-button');
const audioPlayer = document.getElementById('audio-player');
const audioSource = document.getElementById('audio-source');

let flashcards = [];
let currentCardIndex = 0;

// Function to load flashcards from a file and shuffle them
function loadAndShuffleFlashcards() {
    fetch('flashcards.txt')
        .then(response => response.text())
        .then(data => {
            // Split the file content into lines
            const lines = data.split('\n');
            // Trim whitespace and filter out blank lines and comments
            flashcards = lines
                .map(line => line.trim())
                .filter(line => line && !line.startsWith('#'))
                .map(line => {
                    const [question, answer] = line.split(',');
                    return { question, answer };
                });

            // Shuffle the flashcards to randomize the order
            shuffleArray(flashcards);

            showFlashcard();
        })
        .catch(error => console.error('Error loading flashcards: ', error));
}

// Function to display the current flashcard
function showFlashcard() {
    if (flashcards.length === 0) {
        flashcardContainer.innerHTML = 'No flashcards available.';
        return;
    }

    const flashcard = flashcards[currentCardIndex];
    flashcardContainer.innerHTML = `
        <div class="flashcard" id="flashcard">
            <div class="card-front" id="card-front">
                <p>${flashcard.question}</p>
            </div>
            <div class="card-back" id="card-back">
                <p>${flashcard.answer}</p>
            </div>
        </div>
    `;

    // Update the audio source for the current answer
    audioSource.src = `audio/${flashcard.answer}.mp3`;

    // Add a click event to flip the card
    const flashCard = document.getElementById('flashcard');
    const cardFront = document.getElementById('card-front');
    const cardBack = document.getElementById('card-back');
    flashCard.addEventListener('click', () => {
        cardFront.style.transform = 'rotateY(180deg)';
        cardBack.style.transform = 'rotateY(0deg)';
    });

    // Reset the card on the next click
    flashCard.addEventListener('click', () => {
        cardFront.style.transform = 'rotateY(0deg)';
        cardBack.style.transform = 'rotateY(180deg)';
    });
}

// Play the audio when the "Play Audio" button is clicked
playAudioButton.addEventListener('click', () => {
    if (audioPlayer.paused) {
        audioPlayer.load(); // Reset the audio player to play from the beginning
        audioPlayer.play();

        // Pause the audio after 1 second (1000 milliseconds)
        setTimeout(() => {
            audioPlayer.pause();
        }, 1000);
    }
});

nextButton.addEventListener('click', function () {
    currentCardIndex = (currentCardIndex + 1) % flashcards.length;
    showFlashcard();
});

// Load the flashcards and shuffle them when the page loads
loadAndShuffleFlashcards();

// Fisher-Yates shuffle algorithm to shuffle an array
function shuffleArray(array) {
    for (let i = array.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [array[i], array[j]] = [array[j], array[i]];
    }
}